package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CreateTrustStoreResponse(trustStoreArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse = {
    import CreateTrustStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse
      .builder()
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateTrustStoreResponse.wrap(buildAwsValue())
}
object CreateTrustStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateTrustStoreResponse =
      zio.aws.workspacesweb.model.CreateTrustStoreResponse(trustStoreArn)
    def trustStoreArn: ARN
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse
  ) extends zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly {
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse
  ): zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly =
    new Wrapper(impl)
}
