package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workspacesweb.model.primitives.{
  CertificateThumbprint,
  Timestamp,
  CertificatePrincipal
}
import scala.jdk.CollectionConverters._
final case class CertificateSummary(
    issuer: Option[CertificatePrincipal] = None,
    notValidAfter: Option[Timestamp] = None,
    notValidBefore: Option[Timestamp] = None,
    subject: Option[CertificatePrincipal] = None,
    thumbprint: Option[CertificateThumbprint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CertificateSummary
      .builder()
      .optionallyWith(
        issuer.map(value =>
          CertificatePrincipal.unwrap(value): java.lang.String
        )
      )(_.issuer)
      .optionallyWith(
        notValidAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.notValidAfter)
      .optionallyWith(
        notValidBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.notValidBefore)
      .optionallyWith(
        subject.map(value =>
          CertificatePrincipal.unwrap(value): java.lang.String
        )
      )(_.subject)
      .optionallyWith(
        thumbprint.map(value =>
          CertificateThumbprint.unwrap(value): java.lang.String
        )
      )(_.thumbprint)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.CertificateSummary.ReadOnly =
    zio.aws.workspacesweb.model.CertificateSummary.wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CertificateSummary =
      zio.aws.workspacesweb.model.CertificateSummary(
        issuer.map(value => value),
        notValidAfter.map(value => value),
        notValidBefore.map(value => value),
        subject.map(value => value),
        thumbprint.map(value => value)
      )
    def issuer: Option[CertificatePrincipal]
    def notValidAfter: Option[Timestamp]
    def notValidBefore: Option[Timestamp]
    def subject: Option[CertificatePrincipal]
    def thumbprint: Option[CertificateThumbprint]
    def getIssuer: ZIO[Any, AwsError, CertificatePrincipal] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getNotValidAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("notValidAfter", notValidAfter)
    def getNotValidBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("notValidBefore", notValidBefore)
    def getSubject: ZIO[Any, AwsError, CertificatePrincipal] =
      AwsError.unwrapOptionField("subject", subject)
    def getThumbprint: ZIO[Any, AwsError, CertificateThumbprint] =
      AwsError.unwrapOptionField("thumbprint", thumbprint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CertificateSummary
  ) extends zio.aws.workspacesweb.model.CertificateSummary.ReadOnly {
    override val issuer: Option[CertificatePrincipal] = scala
      .Option(impl.issuer())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.CertificatePrincipal(value)
      )
    override val notValidAfter: Option[Timestamp] = scala
      .Option(impl.notValidAfter())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val notValidBefore: Option[Timestamp] = scala
      .Option(impl.notValidBefore())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val subject: Option[CertificatePrincipal] = scala
      .Option(impl.subject())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.CertificatePrincipal(value)
      )
    override val thumbprint: Option[CertificateThumbprint] = scala
      .Option(impl.thumbprint())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.CertificateThumbprint(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CertificateSummary
  ): zio.aws.workspacesweb.model.CertificateSummary.ReadOnly = new Wrapper(impl)
}
