package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{SamlMetadata, ARN}
import scala.jdk.CollectionConverters._
final case class GetPortalServiceProviderMetadataResponse(
    portalArn: ARN,
    serviceProviderSamlMetadata: Option[SamlMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse = {
    import GetPortalServiceProviderMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .optionallyWith(
        serviceProviderSamlMetadata.map(value =>
          SamlMetadata.unwrap(value): java.lang.String
        )
      )(_.serviceProviderSamlMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse
      .wrap(buildAwsValue())
}
object GetPortalServiceProviderMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse =
      zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse(
        portalArn,
        serviceProviderSamlMetadata.map(value => value)
      )
    def portalArn: ARN
    def serviceProviderSamlMetadata: Option[SamlMetadata]
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getServiceProviderSamlMetadata: ZIO[Any, AwsError, SamlMetadata] =
      AwsError.unwrapOptionField(
        "serviceProviderSamlMetadata",
        serviceProviderSamlMetadata
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
  ) extends zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val serviceProviderSamlMetadata: Option[SamlMetadata] = scala
      .Option(impl.serviceProviderSamlMetadata())
      .map(value => zio.aws.workspacesweb.model.primitives.SamlMetadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
  ): zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
