package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DeleteIdentityProviderRequest(identityProviderArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest = {
    import DeleteIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest
      .builder()
      .identityProviderArn(ARN.unwrap(identityProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteIdentityProviderRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteIdentityProviderRequest
      .wrap(buildAwsValue())
}
object DeleteIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteIdentityProviderRequest =
      zio.aws.workspacesweb.model
        .DeleteIdentityProviderRequest(identityProviderArn)
    def identityProviderArn: ARN
    def getIdentityProviderArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(identityProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest
  ) extends zio.aws.workspacesweb.model.DeleteIdentityProviderRequest.ReadOnly {
    override val identityProviderArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.identityProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest
  ): zio.aws.workspacesweb.model.DeleteIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
