package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListNetworkSettingsResponse(
    networkSettings: Option[
      Iterable[zio.aws.workspacesweb.model.NetworkSettingsSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse = {
    import ListNetworkSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse
      .builder()
      .optionallyWith(
        networkSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSettings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListNetworkSettingsResponse
      .wrap(buildAwsValue())
}
object ListNetworkSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListNetworkSettingsResponse =
      zio.aws.workspacesweb.model.ListNetworkSettingsResponse(
        networkSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkSettings: Option[
      List[zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getNetworkSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSettings", networkSettings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly {
    override val networkSettings: Option[
      List[zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly]
    ] = scala
      .Option(impl.networkSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.NetworkSettingsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse
  ): zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
