package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class AssociateUserSettingsResponse(
    portalArn: ARN,
    userSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse = {
    import AssociateUserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateUserSettingsResponse
      .wrap(buildAwsValue())
}
object AssociateUserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.AssociateUserSettingsResponse =
      zio.aws.workspacesweb.model
        .AssociateUserSettingsResponse(portalArn, userSettingsArn)
    def portalArn: ARN
    def userSettingsArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse
  ) extends zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse
  ): zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
