package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait WorkspaceImageErrorDetailCode {
  def unwrap: software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode
}
object WorkspaceImageErrorDetailCode {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode
  ): zio.aws.workspaces.model.WorkspaceImageErrorDetailCode = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OUTDATED_POWERSHELL_VERSION =>
      val r = OutdatedPowershellVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OFFICE_INSTALLED =>
      val r = OfficeInstalled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.P_CO_IP_AGENT_INSTALLED =>
      val r = PCoIPAgentInstalled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WINDOWS_UPDATES_ENABLED =>
      val r = WindowsUpdatesEnabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AUTO_MOUNT_DISABLED =>
      val r = AutoMountDisabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WORKSPACES_BYOL_ACCOUNT_NOT_FOUND =>
      val r = WorkspacesBYOLAccountNotFound
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WORKSPACES_BYOL_ACCOUNT_DISABLED =>
      val r = WorkspacesBYOLAccountDisabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DHCP_DISABLED =>
      val r = DHCPDisabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DISK_FREE_SPACE =>
      val r = DiskFreeSpace
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ADDITIONAL_DRIVES_ATTACHED =>
      val r = AdditionalDrivesAttached
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OS_NOT_SUPPORTED =>
      val r = OSNotSupported
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DOMAIN_JOINED =>
      val r = DomainJoined
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AZURE_DOMAIN_JOINED =>
      val r = AzureDomainJoined
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.FIREWALL_ENABLED =>
      val r = FirewallEnabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.VM_WARE_TOOLS_INSTALLED =>
      val r = VMWareToolsInstalled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DISK_SIZE_EXCEEDED =>
      val r = DiskSizeExceeded
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.INCOMPATIBLE_PARTITIONING =>
      val r = IncompatiblePartitioning
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.PENDING_REBOOT =>
      val r = PendingReboot
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AUTO_LOGON_ENABLED =>
      val r = AutoLogonEnabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.REAL_TIME_UNIVERSAL_DISABLED =>
      val r = RealTimeUniversalDisabled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.MULTIPLE_BOOT_PARTITION =>
      val r = MultipleBootPartition
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.REQUIRES64_BIT_OS =>
      val r = Requires64BitOS
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ZERO_REARM_COUNT =>
      val r = ZeroRearmCount
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.IN_PLACE_UPGRADE =>
      val r = InPlaceUpgrade
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ANTI_VIRUS_INSTALLED =>
      val r = AntiVirusInstalled
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.UEFI_NOT_SUPPORTED =>
      val r = UEFINotSupported
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.UNKNOWN_TO_SDK_VERSION
  }
  case object OutdatedPowershellVersion
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OUTDATED_POWERSHELL_VERSION
  }
  case object OfficeInstalled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OFFICE_INSTALLED
  }
  case object PCoIPAgentInstalled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.P_CO_IP_AGENT_INSTALLED
  }
  case object WindowsUpdatesEnabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WINDOWS_UPDATES_ENABLED
  }
  case object AutoMountDisabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AUTO_MOUNT_DISABLED
  }
  case object WorkspacesBYOLAccountNotFound
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WORKSPACES_BYOL_ACCOUNT_NOT_FOUND
  }
  case object WorkspacesBYOLAccountDisabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.WORKSPACES_BYOL_ACCOUNT_DISABLED
  }
  case object DHCPDisabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DHCP_DISABLED
  }
  case object DiskFreeSpace
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DISK_FREE_SPACE
  }
  case object AdditionalDrivesAttached
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ADDITIONAL_DRIVES_ATTACHED
  }
  case object OSNotSupported
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.OS_NOT_SUPPORTED
  }
  case object DomainJoined
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DOMAIN_JOINED
  }
  case object AzureDomainJoined
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AZURE_DOMAIN_JOINED
  }
  case object FirewallEnabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.FIREWALL_ENABLED
  }
  case object VMWareToolsInstalled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.VM_WARE_TOOLS_INSTALLED
  }
  case object DiskSizeExceeded
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.DISK_SIZE_EXCEEDED
  }
  case object IncompatiblePartitioning
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.INCOMPATIBLE_PARTITIONING
  }
  case object PendingReboot
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.PENDING_REBOOT
  }
  case object AutoLogonEnabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.AUTO_LOGON_ENABLED
  }
  case object RealTimeUniversalDisabled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.REAL_TIME_UNIVERSAL_DISABLED
  }
  case object MultipleBootPartition
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.MULTIPLE_BOOT_PARTITION
  }
  case object Requires64BitOS
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.REQUIRES64_BIT_OS
  }
  case object ZeroRearmCount
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ZERO_REARM_COUNT
  }
  case object InPlaceUpgrade
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.IN_PLACE_UPGRADE
  }
  case object AntiVirusInstalled
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.ANTI_VIRUS_INSTALLED
  }
  case object UEFINotSupported
      extends zio.aws.workspaces.model.WorkspaceImageErrorDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageErrorDetailCode.UEFI_NOT_SUPPORTED
  }
}
