package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait WorkSpaceApplicationLicenseType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType
}
object WorkSpaceApplicationLicenseType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType
  ): zio.aws.workspaces.model.WorkSpaceApplicationLicenseType = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.LICENSED =>
      val r = LICENSED
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.UNLICENSED =>
      val r = UNLICENSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkSpaceApplicationLicenseType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.UNKNOWN_TO_SDK_VERSION
  }
  case object LICENSED
      extends zio.aws.workspaces.model.WorkSpaceApplicationLicenseType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.LICENSED
  }
  case object UNLICENSED
      extends zio.aws.workspaces.model.WorkSpaceApplicationLicenseType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationLicenseType.UNLICENSED
  }
}
