package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Timestamp,
  WorkSpaceApplicationOwner,
  WorkSpaceApplicationId,
  String2048,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class WorkSpaceApplication(
    applicationId: Optional[WorkSpaceApplicationId] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    description: Optional[String2048] = Optional.Absent,
    licenseType: Optional[
      zio.aws.workspaces.model.WorkSpaceApplicationLicenseType
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    owner: Optional[WorkSpaceApplicationOwner] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkSpaceApplicationState] =
      Optional.Absent,
    supportedComputeTypeNames: Optional[
      Iterable[zio.aws.workspaces.model.Compute]
    ] = Optional.Absent,
    supportedOperatingSystemNames: Optional[
      Iterable[zio.aws.workspaces.model.OperatingSystemName]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplication = {
    import WorkSpaceApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkSpaceApplication
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          WorkSpaceApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        description.map(value => String2048.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value =>
          WorkSpaceApplicationOwner.unwrap(value): java.lang.String
        )
      )(_.owner)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        supportedComputeTypeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedComputeTypeNamesWithStrings)
      .optionallyWith(
        supportedOperatingSystemNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedOperatingSystemNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly =
    zio.aws.workspaces.model.WorkSpaceApplication.wrap(buildAwsValue())
}
object WorkSpaceApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkSpaceApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkSpaceApplication =
      zio.aws.workspaces.model.WorkSpaceApplication(
        applicationId.map(value => value),
        created.map(value => value),
        description.map(value => value),
        licenseType.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        state.map(value => value),
        supportedComputeTypeNames.map(value => value),
        supportedOperatingSystemNames.map(value => value)
      )
    def applicationId: Optional[WorkSpaceApplicationId]
    def created: Optional[Timestamp]
    def description: Optional[String2048]
    def licenseType
        : Optional[zio.aws.workspaces.model.WorkSpaceApplicationLicenseType]
    def name: Optional[NonEmptyString]
    def owner: Optional[WorkSpaceApplicationOwner]
    def state: Optional[zio.aws.workspaces.model.WorkSpaceApplicationState]
    def supportedComputeTypeNames
        : Optional[List[zio.aws.workspaces.model.Compute]]
    def supportedOperatingSystemNames
        : Optional[List[zio.aws.workspaces.model.OperatingSystemName]]
    def getApplicationId: ZIO[Any, AwsError, WorkSpaceApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getDescription: ZIO[Any, AwsError, String2048] =
      AwsError.unwrapOptionField("description", description)
    def getLicenseType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkSpaceApplicationLicenseType
    ] = AwsError.unwrapOptionField("licenseType", licenseType)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, WorkSpaceApplicationOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkSpaceApplicationState
    ] = AwsError.unwrapOptionField("state", state)
    def getSupportedComputeTypeNames
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Compute]] = AwsError
      .unwrapOptionField("supportedComputeTypeNames", supportedComputeTypeNames)
    def getSupportedOperatingSystemNames: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.OperatingSystemName
    ]] = AwsError.unwrapOptionField(
      "supportedOperatingSystemNames",
      supportedOperatingSystemNames
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplication
  ) extends zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly {
    override val applicationId: Optional[WorkSpaceApplicationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationId())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkSpaceApplicationId(value)
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val description: Optional[String2048] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspaces.model.primitives.String2048(value))
    override val licenseType
        : Optional[zio.aws.workspaces.model.WorkSpaceApplicationLicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value =>
          zio.aws.workspaces.model.WorkSpaceApplicationLicenseType.wrap(value)
        )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val owner: Optional[WorkSpaceApplicationOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkSpaceApplicationOwner(value)
        )
    override val state
        : Optional[zio.aws.workspaces.model.WorkSpaceApplicationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.workspaces.model.WorkSpaceApplicationState.wrap(value)
        )
    override val supportedComputeTypeNames
        : Optional[List[zio.aws.workspaces.model.Compute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedComputeTypeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Compute.wrap(item)
          }.toList
        )
    override val supportedOperatingSystemNames
        : Optional[List[zio.aws.workspaces.model.OperatingSystemName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOperatingSystemNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.OperatingSystemName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplication
  ): zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly = new Wrapper(impl)
}
