package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TerminateWorkspacesRequest(
    terminateWorkspaceRequests: Iterable[
      zio.aws.workspaces.model.TerminateRequest
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest = {
    import TerminateWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest
      .builder()
      .terminateWorkspaceRequests(terminateWorkspaceRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.TerminateWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.TerminateWorkspacesRequest.wrap(buildAwsValue())
}
object TerminateWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.TerminateWorkspacesRequest =
      zio.aws.workspaces.model
        .TerminateWorkspacesRequest(terminateWorkspaceRequests.map { item =>
          item.asEditable
        })
    def terminateWorkspaceRequests
        : List[zio.aws.workspaces.model.TerminateRequest.ReadOnly]
    def getTerminateWorkspaceRequests: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.TerminateRequest.ReadOnly
    ]] = ZIO.succeed(terminateWorkspaceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest
  ) extends zio.aws.workspaces.model.TerminateWorkspacesRequest.ReadOnly {
    override val terminateWorkspaceRequests
        : List[zio.aws.workspaces.model.TerminateRequest.ReadOnly] = impl
      .terminateWorkspaceRequests()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.TerminateRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest
  ): zio.aws.workspaces.model.TerminateWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
