package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopWorkspacesRequest(
    stopWorkspaceRequests: Iterable[zio.aws.workspaces.model.StopRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest = {
    import StopWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest
      .builder()
      .stopWorkspaceRequests(stopWorkspaceRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.StopWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.StopWorkspacesRequest.wrap(buildAwsValue())
}
object StopWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.StopWorkspacesRequest =
      zio.aws.workspaces.model.StopWorkspacesRequest(stopWorkspaceRequests.map {
        item =>
          item.asEditable
      })
    def stopWorkspaceRequests
        : List[zio.aws.workspaces.model.StopRequest.ReadOnly]
    def getStopWorkspaceRequests: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.StopRequest.ReadOnly
    ]] = ZIO.succeed(stopWorkspaceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest
  ) extends zio.aws.workspaces.model.StopWorkspacesRequest.ReadOnly {
    override val stopWorkspaceRequests
        : List[zio.aws.workspaces.model.StopRequest.ReadOnly] = impl
      .stopWorkspaceRequests()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.StopRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest
  ): zio.aws.workspaces.model.StopWorkspacesRequest.ReadOnly = new Wrapper(impl)
}
