package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{BundleId, WorkspaceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MigrateWorkspaceRequest(
    sourceWorkspaceId: WorkspaceId,
    bundleId: BundleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest = {
    import MigrateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest
      .builder()
      .sourceWorkspaceId(
        WorkspaceId.unwrap(sourceWorkspaceId): java.lang.String
      )
      .bundleId(BundleId.unwrap(bundleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.MigrateWorkspaceRequest.ReadOnly =
    zio.aws.workspaces.model.MigrateWorkspaceRequest.wrap(buildAwsValue())
}
object MigrateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.MigrateWorkspaceRequest =
      zio.aws.workspaces.model
        .MigrateWorkspaceRequest(sourceWorkspaceId, bundleId)
    def sourceWorkspaceId: WorkspaceId
    def bundleId: BundleId
    def getSourceWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(sourceWorkspaceId)
    def getBundleId: ZIO[Any, Nothing, BundleId] = ZIO.succeed(bundleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest
  ) extends zio.aws.workspaces.model.MigrateWorkspaceRequest.ReadOnly {
    override val sourceWorkspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.sourceWorkspaceId())
    override val bundleId: BundleId =
      zio.aws.workspaces.model.primitives.BundleId(impl.bundleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest
  ): zio.aws.workspaces.model.MigrateWorkspaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
