package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  DedicatedTenancyManagementCidrRange
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAvailableManagementCidrRangesResponse(
    managementCidrRanges: Optional[
      Iterable[DedicatedTenancyManagementCidrRange]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse = {
    import ListAvailableManagementCidrRangesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse
      .builder()
      .optionallyWith(
        managementCidrRanges.map(value =>
          value.map { item =>
            DedicatedTenancyManagementCidrRange.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.managementCidrRanges)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly =
    zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse
      .wrap(buildAwsValue())
}
object ListAvailableManagementCidrRangesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse =
      zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse(
        managementCidrRanges.map(value => value),
        nextToken.map(value => value)
      )
    def managementCidrRanges
        : Optional[List[DedicatedTenancyManagementCidrRange]]
    def nextToken: Optional[PaginationToken]
    def getManagementCidrRanges
        : ZIO[Any, AwsError, List[DedicatedTenancyManagementCidrRange]] =
      AwsError.unwrapOptionField("managementCidrRanges", managementCidrRanges)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse
  ) extends zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly {
    override val managementCidrRanges
        : Optional[List[DedicatedTenancyManagementCidrRange]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managementCidrRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives
              .DedicatedTenancyManagementCidrRange(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse
  ): zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly =
    new Wrapper(impl)
}
