package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{Description, ErrorType, WorkspaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailedWorkspaceChangeRequest(
    workspaceId: Optional[WorkspaceId] = Optional.Absent,
    errorCode: Optional[ErrorType] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest = {
    import FailedWorkspaceChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .optionallyWith(
        errorCode.map(value => ErrorType.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly =
    zio.aws.workspaces.model.FailedWorkspaceChangeRequest.wrap(buildAwsValue())
}
object FailedWorkspaceChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.FailedWorkspaceChangeRequest =
      zio.aws.workspaces.model.FailedWorkspaceChangeRequest(
        workspaceId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def workspaceId: Optional[WorkspaceId]
    def errorCode: Optional[ErrorType]
    def errorMessage: Optional[Description]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
    def getErrorCode: ZIO[Any, AwsError, ErrorType] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest
  ) extends zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly {
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
    override val errorCode: Optional[ErrorType] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.workspaces.model.primitives.ErrorType(value))
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.FailedWorkspaceChangeRequest
  ): zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly =
    new Wrapper(impl)
}
