package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{Description, ErrorType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailedCreateWorkspaceRequest(
    workspaceRequest: Optional[zio.aws.workspaces.model.WorkspaceRequest] =
      Optional.Absent,
    errorCode: Optional[ErrorType] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest = {
    import FailedCreateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest
      .builder()
      .optionallyWith(workspaceRequest.map(value => value.buildAwsValue()))(
        _.workspaceRequest
      )
      .optionallyWith(
        errorCode.map(value => ErrorType.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly =
    zio.aws.workspaces.model.FailedCreateWorkspaceRequest.wrap(buildAwsValue())
}
object FailedCreateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.FailedCreateWorkspaceRequest =
      zio.aws.workspaces.model.FailedCreateWorkspaceRequest(
        workspaceRequest.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def workspaceRequest
        : Optional[zio.aws.workspaces.model.WorkspaceRequest.ReadOnly]
    def errorCode: Optional[ErrorType]
    def errorMessage: Optional[Description]
    def getWorkspaceRequest: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceRequest.ReadOnly
    ] = AwsError.unwrapOptionField("workspaceRequest", workspaceRequest)
    def getErrorCode: ZIO[Any, AwsError, ErrorType] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest
  ) extends zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly {
    override val workspaceRequest
        : Optional[zio.aws.workspaces.model.WorkspaceRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceRequest())
        .map(value => zio.aws.workspaces.model.WorkspaceRequest.wrap(value))
    override val errorCode: Optional[ErrorType] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.workspaces.model.primitives.ErrorType(value))
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.FailedCreateWorkspaceRequest
  ): zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly =
    new Wrapper(impl)
}
