package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{WorkSpaceApplicationId, WorkspaceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateWorkspaceApplicationRequest(
    workspaceId: WorkspaceId,
    applicationId: WorkSpaceApplicationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest = {
    import DisassociateWorkspaceApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .applicationId(
        WorkSpaceApplicationId.unwrap(applicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DisassociateWorkspaceApplicationRequest.ReadOnly =
    zio.aws.workspaces.model.DisassociateWorkspaceApplicationRequest
      .wrap(buildAwsValue())
}
object DisassociateWorkspaceApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DisassociateWorkspaceApplicationRequest =
      zio.aws.workspaces.model
        .DisassociateWorkspaceApplicationRequest(workspaceId, applicationId)
    def workspaceId: WorkspaceId
    def applicationId: WorkSpaceApplicationId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getApplicationId: ZIO[Any, Nothing, WorkSpaceApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest
  ) extends zio.aws.workspaces.model.DisassociateWorkspaceApplicationRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val applicationId: WorkSpaceApplicationId =
      zio.aws.workspaces.model.primitives
        .WorkSpaceApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest
  ): zio.aws.workspaces.model.DisassociateWorkspaceApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
