package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceBundlesResponse(
    bundles: Optional[Iterable[zio.aws.workspaces.model.WorkspaceBundle]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse = {
    import DescribeWorkspaceBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse =
      zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse(
        bundles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def bundles
        : Optional[List[zio.aws.workspaces.model.WorkspaceBundle.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getBundles: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundles)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly {
    override val bundles
        : Optional[List[zio.aws.workspaces.model.WorkspaceBundle.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.WorkspaceBundle.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
