package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceAssociationsRequest(
    workspaceId: WorkspaceId,
    associatedResourceTypes: Iterable[
      zio.aws.workspaces.model.WorkSpaceAssociatedResourceType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest = {
    import DescribeWorkspaceAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .associatedResourceTypesWithStrings(associatedResourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest =
      zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest(
        workspaceId,
        associatedResourceTypes
      )
    def workspaceId: WorkspaceId
    def associatedResourceTypes
        : List[zio.aws.workspaces.model.WorkSpaceAssociatedResourceType]
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getAssociatedResourceTypes: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.WorkSpaceAssociatedResourceType
    ]] = ZIO.succeed(associatedResourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val associatedResourceTypes
        : List[zio.aws.workspaces.model.WorkSpaceAssociatedResourceType] = impl
      .associatedResourceTypes()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.WorkSpaceAssociatedResourceType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
