package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeIpGroupsResponse(
    result: Optional[Iterable[zio.aws.workspaces.model.WorkspacesIpGroup]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse = {
    import DescribeIpGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse
      .builder()
      .optionallyWith(
        result.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.result)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeIpGroupsResponse.wrap(buildAwsValue())
}
object DescribeIpGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeIpGroupsResponse =
      zio.aws.workspaces.model.DescribeIpGroupsResponse(
        result.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def result
        : Optional[List[zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getResult: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("result", result)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse
  ) extends zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly {
    override val result
        : Optional[List[zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.WorkspacesIpGroup.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse
  ): zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
