package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeImageAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.workspaces.model.ImageResourceAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse = {
    import DescribeImageAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeImageAssociationsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeImageAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeImageAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeImageAssociationsResponse =
      zio.aws.workspaces.model.DescribeImageAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associations: Optional[
      List[zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly]
    ]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse
  ) extends zio.aws.workspaces.model.DescribeImageAssociationsResponse.ReadOnly {
    override val associations: Optional[
      List[zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ImageResourceAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse
  ): zio.aws.workspaces.model.DescribeImageAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
