package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBundleAssociationsRequest(
    bundleId: BundleId,
    associatedResourceTypes: Iterable[
      zio.aws.workspaces.model.BundleAssociatedResourceType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest = {
    import DescribeBundleAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest
      .builder()
      .bundleId(BundleId.unwrap(bundleId): java.lang.String)
      .associatedResourceTypesWithStrings(associatedResourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeBundleAssociationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeBundleAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeBundleAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeBundleAssociationsRequest =
      zio.aws.workspaces.model
        .DescribeBundleAssociationsRequest(bundleId, associatedResourceTypes)
    def bundleId: BundleId
    def associatedResourceTypes
        : List[zio.aws.workspaces.model.BundleAssociatedResourceType]
    def getBundleId: ZIO[Any, Nothing, BundleId] = ZIO.succeed(bundleId)
    def getAssociatedResourceTypes: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.BundleAssociatedResourceType
    ]] = ZIO.succeed(associatedResourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest
  ) extends zio.aws.workspaces.model.DescribeBundleAssociationsRequest.ReadOnly {
    override val bundleId: BundleId =
      zio.aws.workspaces.model.primitives.BundleId(impl.bundleId())
    override val associatedResourceTypes
        : List[zio.aws.workspaces.model.BundleAssociatedResourceType] = impl
      .associatedResourceTypes()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.BundleAssociatedResourceType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest
  ): zio.aws.workspaces.model.DescribeBundleAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
