package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationsResponse(
    applications: Optional[
      Iterable[zio.aws.workspaces.model.WorkSpaceApplication]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse = {
    import DescribeApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeApplicationsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeApplicationsResponse.wrap(buildAwsValue())
}
object DescribeApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeApplicationsResponse =
      zio.aws.workspaces.model.DescribeApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applications
        : Optional[List[zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse
  ) extends zio.aws.workspaces.model.DescribeApplicationsResponse.ReadOnly {
    override val applications: Optional[
      List[zio.aws.workspaces.model.WorkSpaceApplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.WorkSpaceApplication.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse
  ): zio.aws.workspaces.model.DescribeApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
