package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  Limit,
  WorkSpaceApplicationOwner,
  WorkSpaceApplicationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationsRequest(
    applicationIds: Optional[Iterable[WorkSpaceApplicationId]] =
      Optional.Absent,
    computeTypeNames: Optional[Iterable[zio.aws.workspaces.model.Compute]] =
      Optional.Absent,
    licenseType: Optional[
      zio.aws.workspaces.model.WorkSpaceApplicationLicenseType
    ] = Optional.Absent,
    operatingSystemNames: Optional[
      Iterable[zio.aws.workspaces.model.OperatingSystemName]
    ] = Optional.Absent,
    owner: Optional[WorkSpaceApplicationOwner] = Optional.Absent,
    maxResults: Optional[Limit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest = {
    import DescribeApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest
      .builder()
      .optionallyWith(
        applicationIds.map(value =>
          value.map { item =>
            WorkSpaceApplicationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applicationIds)
      .optionallyWith(
        computeTypeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.computeTypeNamesWithStrings)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(
        operatingSystemNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.operatingSystemNamesWithStrings)
      .optionallyWith(
        owner.map(value =>
          WorkSpaceApplicationOwner.unwrap(value): java.lang.String
        )
      )(_.owner)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeApplicationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeApplicationsRequest.wrap(buildAwsValue())
}
object DescribeApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeApplicationsRequest =
      zio.aws.workspaces.model.DescribeApplicationsRequest(
        applicationIds.map(value => value),
        computeTypeNames.map(value => value),
        licenseType.map(value => value),
        operatingSystemNames.map(value => value),
        owner.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationIds: Optional[List[WorkSpaceApplicationId]]
    def computeTypeNames: Optional[List[zio.aws.workspaces.model.Compute]]
    def licenseType
        : Optional[zio.aws.workspaces.model.WorkSpaceApplicationLicenseType]
    def operatingSystemNames
        : Optional[List[zio.aws.workspaces.model.OperatingSystemName]]
    def owner: Optional[WorkSpaceApplicationOwner]
    def maxResults: Optional[Limit]
    def nextToken: Optional[PaginationToken]
    def getApplicationIds: ZIO[Any, AwsError, List[WorkSpaceApplicationId]] =
      AwsError.unwrapOptionField("applicationIds", applicationIds)
    def getComputeTypeNames
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Compute]] =
      AwsError.unwrapOptionField("computeTypeNames", computeTypeNames)
    def getLicenseType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkSpaceApplicationLicenseType
    ] = AwsError.unwrapOptionField("licenseType", licenseType)
    def getOperatingSystemNames: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.OperatingSystemName
    ]] =
      AwsError.unwrapOptionField("operatingSystemNames", operatingSystemNames)
    def getOwner: ZIO[Any, AwsError, WorkSpaceApplicationOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest
  ) extends zio.aws.workspaces.model.DescribeApplicationsRequest.ReadOnly {
    override val applicationIds: Optional[List[WorkSpaceApplicationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.WorkSpaceApplicationId(item)
          }.toList
        )
    override val computeTypeNames
        : Optional[List[zio.aws.workspaces.model.Compute]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeTypeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Compute.wrap(item)
          }.toList
        )
    override val licenseType
        : Optional[zio.aws.workspaces.model.WorkSpaceApplicationLicenseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value =>
          zio.aws.workspaces.model.WorkSpaceApplicationLicenseType.wrap(value)
        )
    override val operatingSystemNames
        : Optional[List[zio.aws.workspaces.model.OperatingSystemName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.OperatingSystemName.wrap(item)
          }.toList
        )
    override val owner: Optional[WorkSpaceApplicationOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkSpaceApplicationOwner(value)
        )
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest
  ): zio.aws.workspaces.model.DescribeApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
