package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeployWorkspaceApplicationsResponse(
    deployment: Optional[
      zio.aws.workspaces.model.WorkSpaceApplicationDeployment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse = {
    import DeployWorkspaceApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse
      .builder()
      .optionallyWith(deployment.map(value => value.buildAwsValue()))(
        _.deployment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse.ReadOnly =
    zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse
      .wrap(buildAwsValue())
}
object DeployWorkspaceApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse =
      zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse(
        deployment.map(value => value.asEditable)
      )
    def deployment: Optional[
      zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly
    ]
    def getDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("deployment", deployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse
  ) extends zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse.ReadOnly {
    override val deployment: Optional[
      zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deployment())
      .map(value =>
        zio.aws.workspaces.model.WorkSpaceApplicationDeployment.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse
  ): zio.aws.workspaces.model.DeployWorkspaceApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
