package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.IpGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteIpGroupRequest(groupId: IpGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest = {
    import DeleteIpGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest
      .builder()
      .groupId(IpGroupId.unwrap(groupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DeleteIpGroupRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteIpGroupRequest.wrap(buildAwsValue())
}
object DeleteIpGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteIpGroupRequest =
      zio.aws.workspaces.model.DeleteIpGroupRequest(groupId)
    def groupId: IpGroupId
    def getGroupId: ZIO[Any, Nothing, IpGroupId] = ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest
  ) extends zio.aws.workspaces.model.DeleteIpGroupRequest.ReadOnly {
    override val groupId: IpGroupId =
      zio.aws.workspaces.model.primitives.IpGroupId(impl.groupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest
  ): zio.aws.workspaces.model.DeleteIpGroupRequest.ReadOnly = new Wrapper(impl)
}
