package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait DeletableSamlProperty {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty
}
object DeletableSamlProperty {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty
  ): zio.aws.workspaces.model.DeletableSamlProperty = value match {
    case software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.SAML_PROPERTIES_USER_ACCESS_URL =>
      val r = SAML_PROPERTIES_USER_ACCESS_URL
      r
    case software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME =>
      val r = SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.DeletableSamlProperty {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty =
      software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.UNKNOWN_TO_SDK_VERSION
  }
  case object SAML_PROPERTIES_USER_ACCESS_URL
      extends zio.aws.workspaces.model.DeletableSamlProperty {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty =
      software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.SAML_PROPERTIES_USER_ACCESS_URL
  }
  case object SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME
      extends zio.aws.workspaces.model.DeletableSamlProperty {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty =
      software.amazon.awssdk.services.workspaces.model.DeletableSamlProperty.SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME
  }
}
