package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  WorkspaceImageId,
  WorkspaceBundleDescription,
  WorkspaceBundleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceBundleRequest(
    bundleName: WorkspaceBundleName,
    bundleDescription: WorkspaceBundleDescription,
    imageId: WorkspaceImageId,
    computeType: zio.aws.workspaces.model.ComputeType,
    userStorage: zio.aws.workspaces.model.UserStorage,
    rootStorage: Optional[zio.aws.workspaces.model.RootStorage] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest = {
    import CreateWorkspaceBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest
      .builder()
      .bundleName(WorkspaceBundleName.unwrap(bundleName): java.lang.String)
      .bundleDescription(
        WorkspaceBundleDescription.unwrap(bundleDescription): java.lang.String
      )
      .imageId(WorkspaceImageId.unwrap(imageId): java.lang.String)
      .computeType(computeType.buildAwsValue())
      .userStorage(userStorage.buildAwsValue())
      .optionallyWith(rootStorage.map(value => value.buildAwsValue()))(
        _.rootStorage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateWorkspaceBundleRequest.ReadOnly =
    zio.aws.workspaces.model.CreateWorkspaceBundleRequest.wrap(buildAwsValue())
}
object CreateWorkspaceBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateWorkspaceBundleRequest =
      zio.aws.workspaces.model.CreateWorkspaceBundleRequest(
        bundleName,
        bundleDescription,
        imageId,
        computeType.asEditable,
        userStorage.asEditable,
        rootStorage.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bundleName: WorkspaceBundleName
    def bundleDescription: WorkspaceBundleDescription
    def imageId: WorkspaceImageId
    def computeType: zio.aws.workspaces.model.ComputeType.ReadOnly
    def userStorage: zio.aws.workspaces.model.UserStorage.ReadOnly
    def rootStorage: Optional[zio.aws.workspaces.model.RootStorage.ReadOnly]
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getBundleName: ZIO[Any, Nothing, WorkspaceBundleName] =
      ZIO.succeed(bundleName)
    def getBundleDescription: ZIO[Any, Nothing, WorkspaceBundleDescription] =
      ZIO.succeed(bundleDescription)
    def getImageId: ZIO[Any, Nothing, WorkspaceImageId] = ZIO.succeed(imageId)
    def getComputeType
        : ZIO[Any, Nothing, zio.aws.workspaces.model.ComputeType.ReadOnly] =
      ZIO.succeed(computeType)
    def getUserStorage
        : ZIO[Any, Nothing, zio.aws.workspaces.model.UserStorage.ReadOnly] =
      ZIO.succeed(userStorage)
    def getRootStorage
        : ZIO[Any, AwsError, zio.aws.workspaces.model.RootStorage.ReadOnly] =
      AwsError.unwrapOptionField("rootStorage", rootStorage)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest
  ) extends zio.aws.workspaces.model.CreateWorkspaceBundleRequest.ReadOnly {
    override val bundleName: WorkspaceBundleName =
      zio.aws.workspaces.model.primitives.WorkspaceBundleName(impl.bundleName())
    override val bundleDescription: WorkspaceBundleDescription =
      zio.aws.workspaces.model.primitives
        .WorkspaceBundleDescription(impl.bundleDescription())
    override val imageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.imageId())
    override val computeType: zio.aws.workspaces.model.ComputeType.ReadOnly =
      zio.aws.workspaces.model.ComputeType.wrap(impl.computeType())
    override val userStorage: zio.aws.workspaces.model.UserStorage.ReadOnly =
      zio.aws.workspaces.model.UserStorage.wrap(impl.userStorage())
    override val rootStorage
        : Optional[zio.aws.workspaces.model.RootStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootStorage())
        .map(value => zio.aws.workspaces.model.RootStorage.wrap(value))
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest
  ): zio.aws.workspaces.model.CreateWorkspaceBundleRequest.ReadOnly =
    new Wrapper(impl)
}
