package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait BundleAssociatedResourceType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType
}
object BundleAssociatedResourceType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType
  ): zio.aws.workspaces.model.BundleAssociatedResourceType = value match {
    case software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType.APPLICATION =>
      val r = APPLICATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.BundleAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLICATION
      extends zio.aws.workspaces.model.BundleAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.BundleAssociatedResourceType.APPLICATION
  }
}
