package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateWorkspaceApplicationResponse(
    association: Optional[
      zio.aws.workspaces.model.WorkspaceResourceAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse = {
    import AssociateWorkspaceApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse.ReadOnly =
    zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse
      .wrap(buildAwsValue())
}
object AssociateWorkspaceApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse =
      zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse(
        association.map(value => value.asEditable)
      )
    def association: Optional[
      zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly
    ]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse
  ) extends zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse.ReadOnly {
    override val association: Optional[
      zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.association())
      .map(value =>
        zio.aws.workspaces.model.WorkspaceResourceAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse
  ): zio.aws.workspaces.model.AssociateWorkspaceApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
