package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationAssociatedResourceType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType
}
object ApplicationAssociatedResourceType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType
  ): zio.aws.workspaces.model.ApplicationAssociatedResourceType = value match {
    case software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.WORKSPACE =>
      val r = WORKSPACE
      r
    case software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.BUNDLE =>
      val r = BUNDLE
      r
    case software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.IMAGE =>
      val r = IMAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ApplicationAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object WORKSPACE
      extends zio.aws.workspaces.model.ApplicationAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.WORKSPACE
  }
  case object BUNDLE
      extends zio.aws.workspaces.model.ApplicationAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.BUNDLE
  }
  case object IMAGE
      extends zio.aws.workspaces.model.ApplicationAssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType =
      software.amazon.awssdk.services.workspaces.model.ApplicationAssociatedResourceType.IMAGE
  }
}
