package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait AccessPropertyValue {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.AccessPropertyValue
}
object AccessPropertyValue {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.AccessPropertyValue
  ): zio.aws.workspaces.model.AccessPropertyValue = value match {
    case software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.AccessPropertyValue {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AccessPropertyValue =
      software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.workspaces.model.AccessPropertyValue {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AccessPropertyValue =
      software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.ALLOW
  }
  case object DENY extends zio.aws.workspaces.model.AccessPropertyValue {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AccessPropertyValue =
      software.amazon.awssdk.services.workspaces.model.AccessPropertyValue.DENY
  }
}
