package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  BooleanObject,
  BundleId,
  UserName,
  DirectoryId,
  VolumeEncryptionKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkspaceRequest(
    directoryId: DirectoryId,
    userName: UserName,
    bundleId: BundleId,
    volumeEncryptionKey: Optional[VolumeEncryptionKey] = Optional.Absent,
    userVolumeEncryptionEnabled: Optional[BooleanObject] = Optional.Absent,
    rootVolumeEncryptionEnabled: Optional[BooleanObject] = Optional.Absent,
    workspaceProperties: Optional[
      zio.aws.workspaces.model.WorkspaceProperties
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceRequest = {
    import WorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceRequest
      .builder()
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .bundleId(BundleId.unwrap(bundleId): java.lang.String)
      .optionallyWith(
        volumeEncryptionKey.map(value =>
          VolumeEncryptionKey.unwrap(value): java.lang.String
        )
      )(_.volumeEncryptionKey)
      .optionallyWith(
        userVolumeEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.userVolumeEncryptionEnabled)
      .optionallyWith(
        rootVolumeEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.rootVolumeEncryptionEnabled)
      .optionallyWith(workspaceProperties.map(value => value.buildAwsValue()))(
        _.workspaceProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceRequest.ReadOnly =
    zio.aws.workspaces.model.WorkspaceRequest.wrap(buildAwsValue())
}
object WorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceRequest =
      zio.aws.workspaces.model.WorkspaceRequest(
        directoryId,
        userName,
        bundleId,
        volumeEncryptionKey.map(value => value),
        userVolumeEncryptionEnabled.map(value => value),
        rootVolumeEncryptionEnabled.map(value => value),
        workspaceProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def directoryId: DirectoryId
    def userName: UserName
    def bundleId: BundleId
    def volumeEncryptionKey: Optional[VolumeEncryptionKey]
    def userVolumeEncryptionEnabled: Optional[BooleanObject]
    def rootVolumeEncryptionEnabled: Optional[BooleanObject]
    def workspaceProperties
        : Optional[zio.aws.workspaces.model.WorkspaceProperties.ReadOnly]
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getBundleId: ZIO[Any, Nothing, BundleId] = ZIO.succeed(bundleId)
    def getVolumeEncryptionKey: ZIO[Any, AwsError, VolumeEncryptionKey] =
      AwsError.unwrapOptionField("volumeEncryptionKey", volumeEncryptionKey)
    def getUserVolumeEncryptionEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "userVolumeEncryptionEnabled",
        userVolumeEncryptionEnabled
      )
    def getRootVolumeEncryptionEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "rootVolumeEncryptionEnabled",
        rootVolumeEncryptionEnabled
      )
    def getWorkspaceProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("workspaceProperties", workspaceProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceRequest
  ) extends zio.aws.workspaces.model.WorkspaceRequest.ReadOnly {
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
    override val userName: UserName =
      zio.aws.workspaces.model.primitives.UserName(impl.userName())
    override val bundleId: BundleId =
      zio.aws.workspaces.model.primitives.BundleId(impl.bundleId())
    override val volumeEncryptionKey: Optional[VolumeEncryptionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeEncryptionKey())
        .map(value =>
          zio.aws.workspaces.model.primitives.VolumeEncryptionKey(value)
        )
    override val userVolumeEncryptionEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userVolumeEncryptionEnabled())
        .map(value => value: BooleanObject)
    override val rootVolumeEncryptionEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootVolumeEncryptionEnabled())
        .map(value => value: BooleanObject)
    override val workspaceProperties
        : Optional[zio.aws.workspaces.model.WorkspaceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceProperties())
        .map(value => zio.aws.workspaces.model.WorkspaceProperties.wrap(value))
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceRequest
  ): zio.aws.workspaces.model.WorkspaceRequest.ReadOnly = new Wrapper(impl)
}
