package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Timestamp,
  Description,
  BundleOwner,
  WorkspaceImageId,
  BundleId,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class WorkspaceBundle(
    bundleId: Optional[BundleId] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    owner: Optional[BundleOwner] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    imageId: Optional[WorkspaceImageId] = Optional.Absent,
    rootStorage: Optional[zio.aws.workspaces.model.RootStorage] =
      Optional.Absent,
    userStorage: Optional[zio.aws.workspaces.model.UserStorage] =
      Optional.Absent,
    computeType: Optional[zio.aws.workspaces.model.ComputeType] =
      Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkspaceBundleState] =
      Optional.Absent,
    bundleType: Optional[zio.aws.workspaces.model.BundleType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceBundle = {
    import WorkspaceBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
      .builder()
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => BundleOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(rootStorage.map(value => value.buildAwsValue()))(
        _.rootStorage
      )
      .optionallyWith(userStorage.map(value => value.buildAwsValue()))(
        _.userStorage
      )
      .optionallyWith(computeType.map(value => value.buildAwsValue()))(
        _.computeType
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(bundleType.map(value => value.unwrap))(_.bundleType)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceBundle.ReadOnly =
    zio.aws.workspaces.model.WorkspaceBundle.wrap(buildAwsValue())
}
object WorkspaceBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceBundle =
      zio.aws.workspaces.model.WorkspaceBundle(
        bundleId.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        description.map(value => value),
        imageId.map(value => value),
        rootStorage.map(value => value.asEditable),
        userStorage.map(value => value.asEditable),
        computeType.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        creationTime.map(value => value),
        state.map(value => value),
        bundleType.map(value => value)
      )
    def bundleId: Optional[BundleId]
    def name: Optional[NonEmptyString]
    def owner: Optional[BundleOwner]
    def description: Optional[Description]
    def imageId: Optional[WorkspaceImageId]
    def rootStorage: Optional[zio.aws.workspaces.model.RootStorage.ReadOnly]
    def userStorage: Optional[zio.aws.workspaces.model.UserStorage.ReadOnly]
    def computeType: Optional[zio.aws.workspaces.model.ComputeType.ReadOnly]
    def lastUpdatedTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def state: Optional[zio.aws.workspaces.model.WorkspaceBundleState]
    def bundleType: Optional[zio.aws.workspaces.model.BundleType]
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, BundleOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getRootStorage
        : ZIO[Any, AwsError, zio.aws.workspaces.model.RootStorage.ReadOnly] =
      AwsError.unwrapOptionField("rootStorage", rootStorage)
    def getUserStorage
        : ZIO[Any, AwsError, zio.aws.workspaces.model.UserStorage.ReadOnly] =
      AwsError.unwrapOptionField("userStorage", userStorage)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ComputeType.ReadOnly] =
      AwsError.unwrapOptionField("computeType", computeType)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceBundleState] =
      AwsError.unwrapOptionField("state", state)
    def getBundleType: ZIO[Any, AwsError, zio.aws.workspaces.model.BundleType] =
      AwsError.unwrapOptionField("bundleType", bundleType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ) extends zio.aws.workspaces.model.WorkspaceBundle.ReadOnly {
    override val bundleId: Optional[BundleId] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val owner: Optional[BundleOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.workspaces.model.primitives.BundleOwner(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val rootStorage
        : Optional[zio.aws.workspaces.model.RootStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootStorage())
        .map(value => zio.aws.workspaces.model.RootStorage.wrap(value))
    override val userStorage
        : Optional[zio.aws.workspaces.model.UserStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStorage())
        .map(value => zio.aws.workspaces.model.UserStorage.wrap(value))
    override val computeType
        : Optional[zio.aws.workspaces.model.ComputeType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeType())
        .map(value => zio.aws.workspaces.model.ComputeType.wrap(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val state
        : Optional[zio.aws.workspaces.model.WorkspaceBundleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.WorkspaceBundleState.wrap(value))
    override val bundleType: Optional[zio.aws.workspaces.model.BundleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundleType())
        .map(value => zio.aws.workspaces.model.BundleType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ): zio.aws.workspaces.model.WorkspaceBundle.ReadOnly = new Wrapper(impl)
}
