package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SelfservicePermissions(
    restartWorkspace: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent,
    increaseVolumeSize: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent,
    changeComputeType: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent,
    switchRunningMode: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent,
    rebuildWorkspace: Optional[zio.aws.workspaces.model.ReconnectEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.SelfservicePermissions = {
    import SelfservicePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
      .builder()
      .optionallyWith(restartWorkspace.map(value => value.unwrap))(
        _.restartWorkspace
      )
      .optionallyWith(increaseVolumeSize.map(value => value.unwrap))(
        _.increaseVolumeSize
      )
      .optionallyWith(changeComputeType.map(value => value.unwrap))(
        _.changeComputeType
      )
      .optionallyWith(switchRunningMode.map(value => value.unwrap))(
        _.switchRunningMode
      )
      .optionallyWith(rebuildWorkspace.map(value => value.unwrap))(
        _.rebuildWorkspace
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.SelfservicePermissions.ReadOnly =
    zio.aws.workspaces.model.SelfservicePermissions.wrap(buildAwsValue())
}
object SelfservicePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.SelfservicePermissions =
      zio.aws.workspaces.model.SelfservicePermissions(
        restartWorkspace.map(value => value),
        increaseVolumeSize.map(value => value),
        changeComputeType.map(value => value),
        switchRunningMode.map(value => value),
        rebuildWorkspace.map(value => value)
      )
    def restartWorkspace: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def increaseVolumeSize: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def changeComputeType: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def switchRunningMode: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def rebuildWorkspace: Optional[zio.aws.workspaces.model.ReconnectEnum]
    def getRestartWorkspace
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("restartWorkspace", restartWorkspace)
    def getIncreaseVolumeSize
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("increaseVolumeSize", increaseVolumeSize)
    def getChangeComputeType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("changeComputeType", changeComputeType)
    def getSwitchRunningMode
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("switchRunningMode", switchRunningMode)
    def getRebuildWorkspace
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("rebuildWorkspace", rebuildWorkspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ) extends zio.aws.workspaces.model.SelfservicePermissions.ReadOnly {
    override val restartWorkspace
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restartWorkspace())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val increaseVolumeSize
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.increaseVolumeSize())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val changeComputeType
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeComputeType())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val switchRunningMode
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.switchRunningMode())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val rebuildWorkspace
        : Optional[zio.aws.workspaces.model.ReconnectEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rebuildWorkspace())
        .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ): zio.aws.workspaces.model.SelfservicePermissions.ReadOnly = new Wrapper(
    impl
  )
}
