package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModifyWorkspaceAccessPropertiesRequest(
    resourceId: DirectoryId,
    workspaceAccessProperties: zio.aws.workspaces.model.WorkspaceAccessProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest = {
    import ModifyWorkspaceAccessPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .workspaceAccessProperties(workspaceAccessProperties.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
      .wrap(buildAwsValue())
}
object ModifyWorkspaceAccessPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest =
      zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest(
        resourceId,
        workspaceAccessProperties.asEditable
      )
    def resourceId: DirectoryId
    def workspaceAccessProperties
        : zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getWorkspaceAccessProperties: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly
    ] = ZIO.succeed(workspaceAccessProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
  ) extends zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val workspaceAccessProperties
        : zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly =
      zio.aws.workspaces.model.WorkspaceAccessProperties
        .wrap(impl.workspaceAccessProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest
  ): zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
