package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, WorkspaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesConnectionStatusRequest(
    workspaceIds: Optional[Iterable[WorkspaceId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest = {
    import DescribeWorkspacesConnectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
      .builder()
      .optionallyWith(
        workspaceIds.map(value =>
          value.map { item =>
            WorkspaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspacesConnectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest =
      zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest(
        workspaceIds.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceIds: Optional[List[WorkspaceId]]
    def nextToken: Optional[PaginationToken]
    def getWorkspaceIds: ZIO[Any, AwsError, List[WorkspaceId]] =
      AwsError.unwrapOptionField("workspaceIds", workspaceIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly {
    override val workspaceIds: Optional[List[WorkspaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.WorkspaceId(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ): zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
