package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  BundleOwner,
  BundleId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceBundlesRequest(
    bundleIds: Optional[Iterable[BundleId]] = Optional.Absent,
    owner: Optional[BundleOwner] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest = {
    import DescribeWorkspaceBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest
      .builder()
      .optionallyWith(
        bundleIds.map(value =>
          value.map { item =>
            BundleId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bundleIds)
      .optionallyWith(
        owner.map(value => BundleOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest =
      zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest(
        bundleIds.map(value => value),
        owner.map(value => value),
        nextToken.map(value => value)
      )
    def bundleIds: Optional[List[BundleId]]
    def owner: Optional[BundleOwner]
    def nextToken: Optional[PaginationToken]
    def getBundleIds: ZIO[Any, AwsError, List[BundleId]] =
      AwsError.unwrapOptionField("bundleIds", bundleIds)
    def getOwner: ZIO[Any, AwsError, BundleOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest.ReadOnly {
    override val bundleIds: Optional[List[BundleId]] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.BundleId(item)
        }.toList
      )
    override val owner: Optional[BundleOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.workspaces.model.primitives.BundleOwner(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceBundlesRequest.ReadOnly =
    new Wrapper(impl)
}
