package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountModificationsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest = {
    import DescribeAccountModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeAccountModificationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeAccountModificationsRequest
      .wrap(buildAwsValue())
}
object DescribeAccountModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeAccountModificationsRequest =
      zio.aws.workspaces.model
        .DescribeAccountModificationsRequest(nextToken.map(value => value))
    def nextToken: Optional[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest
  ) extends zio.aws.workspaces.model.DescribeAccountModificationsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest
  ): zio.aws.workspaces.model.DescribeAccountModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
