package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkspacesResponse(
    failedRequests: Optional[
      Iterable[zio.aws.workspaces.model.FailedCreateWorkspaceRequest]
    ] = Optional.Absent,
    pendingRequests: Optional[Iterable[zio.aws.workspaces.model.Workspace]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse = {
    import CreateWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse
      .builder()
      .optionallyWith(
        failedRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedRequests)
      .optionallyWith(
        pendingRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingRequests)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.CreateWorkspacesResponse.wrap(buildAwsValue())
}
object CreateWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateWorkspacesResponse =
      zio.aws.workspaces.model.CreateWorkspacesResponse(
        failedRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedRequests: Optional[
      List[zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly]
    ]
    def pendingRequests
        : Optional[List[zio.aws.workspaces.model.Workspace.ReadOnly]]
    def getFailedRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("failedRequests", failedRequests)
    def getPendingRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.Workspace.ReadOnly
    ]] = AwsError.unwrapOptionField("pendingRequests", pendingRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse
  ) extends zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly {
    override val failedRequests: Optional[
      List[zio.aws.workspaces.model.FailedCreateWorkspaceRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.FailedCreateWorkspaceRequest.wrap(item)
        }.toList
      )
    override val pendingRequests
        : Optional[List[zio.aws.workspaces.model.Workspace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Workspace.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse
  ): zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
