package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionState {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ConnectionState
}
object ConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ConnectionState
  ): zio.aws.workspaces.model.ConnectionState = value match {
    case software.amazon.awssdk.services.workspaces.model.ConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionState.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionState.DISCONNECTED =>
      val r = DISCONNECTED
      r
    case software.amazon.awssdk.services.workspaces.model.ConnectionState.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionState =
      software.amazon.awssdk.services.workspaces.model.ConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.workspaces.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionState =
      software.amazon.awssdk.services.workspaces.model.ConnectionState.CONNECTED
  }
  case object DISCONNECTED extends zio.aws.workspaces.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionState =
      software.amazon.awssdk.services.workspaces.model.ConnectionState.DISCONNECTED
  }
  case object UNKNOWN extends zio.aws.workspaces.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ConnectionState =
      software.amazon.awssdk.services.workspaces.model.ConnectionState.UNKNOWN
  }
}
