package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateConnectionAliasResponse(
    connectionIdentifier: Optional[ConnectionIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse = {
    import AssociateConnectionAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse
      .builder()
      .optionallyWith(
        connectionIdentifier.map(value =>
          ConnectionIdentifier.unwrap(value): java.lang.String
        )
      )(_.connectionIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly =
    zio.aws.workspaces.model.AssociateConnectionAliasResponse
      .wrap(buildAwsValue())
}
object AssociateConnectionAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AssociateConnectionAliasResponse =
      zio.aws.workspaces.model.AssociateConnectionAliasResponse(
        connectionIdentifier.map(value => value)
      )
    def connectionIdentifier: Optional[ConnectionIdentifier]
    def getConnectionIdentifier: ZIO[Any, AwsError, ConnectionIdentifier] =
      AwsError.unwrapOptionField("connectionIdentifier", connectionIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse
  ) extends zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly {
    override val connectionIdentifier: Optional[ConnectionIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionIdentifier())
        .map(value =>
          zio.aws.workspaces.model.primitives.ConnectionIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse
  ): zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly =
    new Wrapper(impl)
}
