package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait Application {
  def unwrap: software.amazon.awssdk.services.workspaces.model.Application
}
object Application {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.Application
  ): zio.aws.workspaces.model.Application = value match {
    case software.amazon.awssdk.services.workspaces.model.Application.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.Application.MICROSOFT_OFFICE_2016 =>
      val r = Microsoft_Office_2016
      r
    case software.amazon.awssdk.services.workspaces.model.Application.MICROSOFT_OFFICE_2019 =>
      val r = Microsoft_Office_2019
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.Application {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Application =
      software.amazon.awssdk.services.workspaces.model.Application.UNKNOWN_TO_SDK_VERSION
  }
  case object Microsoft_Office_2016
      extends zio.aws.workspaces.model.Application {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Application =
      software.amazon.awssdk.services.workspaces.model.Application.MICROSOFT_OFFICE_2016
  }
  case object Microsoft_Office_2019
      extends zio.aws.workspaces.model.Application {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Application =
      software.amazon.awssdk.services.workspaces.model.Application.MICROSOFT_OFFICE_2019
  }
}
