package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Description,
  WorkspaceErrorCode,
  Timestamp,
  DedicatedTenancyManagementCidrRange
}
import scala.jdk.CollectionConverters.*
final case class AccountModification(
    modificationState: Optional[
      zio.aws.workspaces.model.DedicatedTenancyModificationStateEnum
    ] = Optional.Absent,
    dedicatedTenancySupport: Optional[
      zio.aws.workspaces.model.DedicatedTenancySupportResultEnum
    ] = Optional.Absent,
    dedicatedTenancyManagementCidrRange: Optional[
      DedicatedTenancyManagementCidrRange
    ] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    errorCode: Optional[WorkspaceErrorCode] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AccountModification = {
    import AccountModification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AccountModification
      .builder()
      .optionallyWith(modificationState.map(value => value.unwrap))(
        _.modificationState
      )
      .optionallyWith(dedicatedTenancySupport.map(value => value.unwrap))(
        _.dedicatedTenancySupport
      )
      .optionallyWith(
        dedicatedTenancyManagementCidrRange.map(value =>
          DedicatedTenancyManagementCidrRange.unwrap(value): java.lang.String
        )
      )(_.dedicatedTenancyManagementCidrRange)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        errorCode.map(value =>
          WorkspaceErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.AccountModification.ReadOnly =
    zio.aws.workspaces.model.AccountModification.wrap(buildAwsValue())
}
object AccountModification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AccountModification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AccountModification =
      zio.aws.workspaces.model.AccountModification(
        modificationState.map(value => value),
        dedicatedTenancySupport.map(value => value),
        dedicatedTenancyManagementCidrRange.map(value => value),
        startTime.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def modificationState: Optional[
      zio.aws.workspaces.model.DedicatedTenancyModificationStateEnum
    ]
    def dedicatedTenancySupport
        : Optional[zio.aws.workspaces.model.DedicatedTenancySupportResultEnum]
    def dedicatedTenancyManagementCidrRange
        : Optional[DedicatedTenancyManagementCidrRange]
    def startTime: Optional[Timestamp]
    def errorCode: Optional[WorkspaceErrorCode]
    def errorMessage: Optional[Description]
    def getModificationState: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DedicatedTenancyModificationStateEnum
    ] = AwsError.unwrapOptionField("modificationState", modificationState)
    def getDedicatedTenancySupport: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DedicatedTenancySupportResultEnum
    ] = AwsError.unwrapOptionField(
      "dedicatedTenancySupport",
      dedicatedTenancySupport
    )
    def getDedicatedTenancyManagementCidrRange
        : ZIO[Any, AwsError, DedicatedTenancyManagementCidrRange] =
      AwsError.unwrapOptionField(
        "dedicatedTenancyManagementCidrRange",
        dedicatedTenancyManagementCidrRange
      )
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getErrorCode: ZIO[Any, AwsError, WorkspaceErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AccountModification
  ) extends zio.aws.workspaces.model.AccountModification.ReadOnly {
    override val modificationState: Optional[
      zio.aws.workspaces.model.DedicatedTenancyModificationStateEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modificationState())
      .map(value =>
        zio.aws.workspaces.model.DedicatedTenancyModificationStateEnum
          .wrap(value)
      )
    override val dedicatedTenancySupport
        : Optional[zio.aws.workspaces.model.DedicatedTenancySupportResultEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedTenancySupport())
        .map(value =>
          zio.aws.workspaces.model.DedicatedTenancySupportResultEnum.wrap(value)
        )
    override val dedicatedTenancyManagementCidrRange
        : Optional[DedicatedTenancyManagementCidrRange] = zio.aws.core.internal
      .optionalFromNullable(impl.dedicatedTenancyManagementCidrRange())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .DedicatedTenancyManagementCidrRange(value)
      )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val errorCode: Optional[WorkspaceErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceErrorCode(value)
      )
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AccountModification
  ): zio.aws.workspaces.model.AccountModification.ReadOnly = new Wrapper(impl)
}
