package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  WorkspaceId,
  Timestamp,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class WorkspaceResourceAssociation(
    associatedResourceId: Optional[NonEmptyString] = Optional.Absent,
    associatedResourceType: Optional[
      zio.aws.workspaces.model.WorkSpaceAssociatedResourceType
    ] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.AssociationState] =
      Optional.Absent,
    stateReason: Optional[zio.aws.workspaces.model.AssociationStateReason] =
      Optional.Absent,
    workspaceId: Optional[WorkspaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation = {
    import WorkspaceResourceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation
      .builder()
      .optionallyWith(
        associatedResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associatedResourceId)
      .optionallyWith(associatedResourceType.map(value => value.unwrap))(
        _.associatedResourceType
      )
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly =
    zio.aws.workspaces.model.WorkspaceResourceAssociation.wrap(buildAwsValue())
}
object WorkspaceResourceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceResourceAssociation =
      zio.aws.workspaces.model.WorkspaceResourceAssociation(
        associatedResourceId.map(value => value),
        associatedResourceType.map(value => value),
        created.map(value => value),
        lastUpdatedTime.map(value => value),
        state.map(value => value),
        stateReason.map(value => value.asEditable),
        workspaceId.map(value => value)
      )
    def associatedResourceId: Optional[NonEmptyString]
    def associatedResourceType
        : Optional[zio.aws.workspaces.model.WorkSpaceAssociatedResourceType]
    def created: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def state: Optional[zio.aws.workspaces.model.AssociationState]
    def stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly]
    def workspaceId: Optional[WorkspaceId]
    def getAssociatedResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associatedResourceId", associatedResourceId)
    def getAssociatedResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkSpaceAssociatedResourceType
    ] = AwsError.unwrapOptionField(
      "associatedResourceType",
      associatedResourceType
    )
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.AssociationStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateReason", stateReason)
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation
  ) extends zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly {
    override val associatedResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceId())
        .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val associatedResourceType
        : Optional[zio.aws.workspaces.model.WorkSpaceAssociatedResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceType())
        .map(value =>
          zio.aws.workspaces.model.WorkSpaceAssociatedResourceType.wrap(value)
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.workspaces.model.AssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.AssociationState.wrap(value))
    override val stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.workspaces.model.AssociationStateReason.wrap(value)
        )
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceResourceAssociation
  ): zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly =
    new Wrapper(impl)
}
