package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  UserVolumeSizeGib,
  RootVolumeSizeGib,
  RunningModeAutoStopTimeoutInMinutes
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WorkspaceProperties(
    runningMode: Optional[zio.aws.workspaces.model.RunningMode] =
      Optional.Absent,
    runningModeAutoStopTimeoutInMinutes: Optional[
      RunningModeAutoStopTimeoutInMinutes
    ] = Optional.Absent,
    rootVolumeSizeGib: Optional[RootVolumeSizeGib] = Optional.Absent,
    userVolumeSizeGib: Optional[UserVolumeSizeGib] = Optional.Absent,
    computeTypeName: Optional[zio.aws.workspaces.model.Compute] =
      Optional.Absent,
    protocols: Optional[Iterable[zio.aws.workspaces.model.Protocol]] =
      Optional.Absent,
    operatingSystemName: Optional[
      zio.aws.workspaces.model.OperatingSystemName
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceProperties = {
    import WorkspaceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceProperties
      .builder()
      .optionallyWith(runningMode.map(value => value.unwrap))(_.runningMode)
      .optionallyWith(
        runningModeAutoStopTimeoutInMinutes.map(value =>
          RunningModeAutoStopTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.runningModeAutoStopTimeoutInMinutes)
      .optionallyWith(
        rootVolumeSizeGib.map(value => RootVolumeSizeGib.unwrap(value): Integer)
      )(_.rootVolumeSizeGib)
      .optionallyWith(
        userVolumeSizeGib.map(value => UserVolumeSizeGib.unwrap(value): Integer)
      )(_.userVolumeSizeGib)
      .optionallyWith(computeTypeName.map(value => value.unwrap))(
        _.computeTypeName
      )
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(operatingSystemName.map(value => value.unwrap))(
        _.operatingSystemName
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceProperties.ReadOnly =
    zio.aws.workspaces.model.WorkspaceProperties.wrap(buildAwsValue())
}
object WorkspaceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceProperties =
      zio.aws.workspaces.model.WorkspaceProperties(
        runningMode.map(value => value),
        runningModeAutoStopTimeoutInMinutes.map(value => value),
        rootVolumeSizeGib.map(value => value),
        userVolumeSizeGib.map(value => value),
        computeTypeName.map(value => value),
        protocols.map(value => value),
        operatingSystemName.map(value => value)
      )
    def runningMode: Optional[zio.aws.workspaces.model.RunningMode]
    def runningModeAutoStopTimeoutInMinutes
        : Optional[RunningModeAutoStopTimeoutInMinutes]
    def rootVolumeSizeGib: Optional[RootVolumeSizeGib]
    def userVolumeSizeGib: Optional[UserVolumeSizeGib]
    def computeTypeName: Optional[zio.aws.workspaces.model.Compute]
    def protocols: Optional[List[zio.aws.workspaces.model.Protocol]]
    def operatingSystemName
        : Optional[zio.aws.workspaces.model.OperatingSystemName]
    def getRunningMode
        : ZIO[Any, AwsError, zio.aws.workspaces.model.RunningMode] =
      AwsError.unwrapOptionField("runningMode", runningMode)
    def getRunningModeAutoStopTimeoutInMinutes
        : ZIO[Any, AwsError, RunningModeAutoStopTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "runningModeAutoStopTimeoutInMinutes",
        runningModeAutoStopTimeoutInMinutes
      )
    def getRootVolumeSizeGib: ZIO[Any, AwsError, RootVolumeSizeGib] =
      AwsError.unwrapOptionField("rootVolumeSizeGib", rootVolumeSizeGib)
    def getUserVolumeSizeGib: ZIO[Any, AwsError, UserVolumeSizeGib] =
      AwsError.unwrapOptionField("userVolumeSizeGib", userVolumeSizeGib)
    def getComputeTypeName
        : ZIO[Any, AwsError, zio.aws.workspaces.model.Compute] =
      AwsError.unwrapOptionField("computeTypeName", computeTypeName)
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getOperatingSystemName
        : ZIO[Any, AwsError, zio.aws.workspaces.model.OperatingSystemName] =
      AwsError.unwrapOptionField("operatingSystemName", operatingSystemName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceProperties
  ) extends zio.aws.workspaces.model.WorkspaceProperties.ReadOnly {
    override val runningMode: Optional[zio.aws.workspaces.model.RunningMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runningMode())
        .map(value => zio.aws.workspaces.model.RunningMode.wrap(value))
    override val runningModeAutoStopTimeoutInMinutes
        : Optional[RunningModeAutoStopTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.runningModeAutoStopTimeoutInMinutes())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .RunningModeAutoStopTimeoutInMinutes(value)
      )
    override val rootVolumeSizeGib: Optional[RootVolumeSizeGib] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootVolumeSizeGib())
        .map(value =>
          zio.aws.workspaces.model.primitives.RootVolumeSizeGib(value)
        )
    override val userVolumeSizeGib: Optional[UserVolumeSizeGib] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userVolumeSizeGib())
        .map(value =>
          zio.aws.workspaces.model.primitives.UserVolumeSizeGib(value)
        )
    override val computeTypeName: Optional[zio.aws.workspaces.model.Compute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeTypeName())
        .map(value => zio.aws.workspaces.model.Compute.wrap(value))
    override val protocols: Optional[List[zio.aws.workspaces.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Protocol.wrap(item)
          }.toList
        )
    override val operatingSystemName
        : Optional[zio.aws.workspaces.model.OperatingSystemName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemName())
        .map(value => zio.aws.workspaces.model.OperatingSystemName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceProperties
  ): zio.aws.workspaces.model.WorkspaceProperties.ReadOnly = new Wrapper(impl)
}
