package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait WorkspaceImageState {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.WorkspaceImageState
}
object WorkspaceImageState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceImageState
  ): zio.aws.workspaces.model.WorkspaceImageState = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceImageState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.workspaces.model.WorkspaceImageState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.AVAILABLE
  }
  case object PENDING extends zio.aws.workspaces.model.WorkspaceImageState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.PENDING
  }
  case object ERROR extends zio.aws.workspaces.model.WorkspaceImageState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageState.ERROR
  }
}
