package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait WorkspaceBundleState {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState
}
object WorkspaceBundleState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState
  ): zio.aws.workspaces.model.WorkspaceBundleState = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceBundleState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.workspaces.model.WorkspaceBundleState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.AVAILABLE
  }
  case object PENDING extends zio.aws.workspaces.model.WorkspaceBundleState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.PENDING
  }
  case object ERROR extends zio.aws.workspaces.model.WorkspaceBundleState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState =
      software.amazon.awssdk.services.workspaces.model.WorkspaceBundleState.ERROR
  }
}
