package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait WorkSpaceApplicationState {
  def unwrap: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState
}
object WorkSpaceApplicationState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState
  ): zio.aws.workspaces.model.WorkSpaceApplicationState = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.UNINSTALL_ONLY =>
      val r = UNINSTALL_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkSpaceApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.workspaces.model.WorkSpaceApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.PENDING
  }
  case object ERROR extends zio.aws.workspaces.model.WorkSpaceApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.ERROR
  }
  case object AVAILABLE
      extends zio.aws.workspaces.model.WorkSpaceApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.AVAILABLE
  }
  case object UNINSTALL_ONLY
      extends zio.aws.workspaces.model.WorkSpaceApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState =
      software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationState.UNINSTALL_ONLY
  }
}
