package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkSpaceApplicationDeployment(
    associations: Optional[
      Iterable[zio.aws.workspaces.model.WorkspaceResourceAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationDeployment = {
    import WorkSpaceApplicationDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationDeployment
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly =
    zio.aws.workspaces.model.WorkSpaceApplicationDeployment
      .wrap(buildAwsValue())
}
object WorkSpaceApplicationDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkSpaceApplicationDeployment =
      zio.aws.workspaces.model.WorkSpaceApplicationDeployment(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associations: Optional[
      List[zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly]
    ]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationDeployment
  ) extends zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly {
    override val associations: Optional[
      List[zio.aws.workspaces.model.WorkspaceResourceAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.WorkspaceResourceAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkSpaceApplicationDeployment
  ): zio.aws.workspaces.model.WorkSpaceApplicationDeployment.ReadOnly =
    new Wrapper(impl)
}
