package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopRequest(
    workspaceId: Optional[WorkspaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.StopRequest = {
    import StopRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.StopRequest
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.StopRequest.ReadOnly =
    zio.aws.workspaces.model.StopRequest.wrap(buildAwsValue())
}
object StopRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.StopRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.StopRequest =
      zio.aws.workspaces.model.StopRequest(workspaceId.map(value => value))
    def workspaceId: Optional[WorkspaceId]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.StopRequest
  ) extends zio.aws.workspaces.model.StopRequest.ReadOnly {
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.StopRequest
  ): zio.aws.workspaces.model.StopRequest.ReadOnly = new Wrapper(impl)
}
